﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace WindowsFormsApplication1
{
    public partial class FormMain : Form
    {
        // Create an object for Bld04aCommand.
        public Bld04aCommand bld04aCommand;
        


        public FormMain()
        {
            InitializeComponent();

            // Create a graphics object for the picture box
            this.graphicsReadSpeed = this.pictureBoxReadSpeed.CreateGraphics();

            // Create a Bld04aCommand object.
            this.bld04aCommand = new Bld04aCommand(this.serialPort);
        }



        private void formMain_Load(object sender, EventArgs e)
        {
            // Refresh the COM List combo box.
            this.refreshComList();

            // Refresh the Baud Rate List combo box.
            this.refreshBaudRateList();



            // Update the speed value in the label.
            this.labelSetSpeed.Text = "Set Speed: " + this.hScrollBarSetSpeed.Value.ToString();

            // Add the controls that we need to enable when the BLD04A is connected.
            this.controlList_ControlsToBeEnabledUponConnected.Add(this.groupBoxMotorControl);
            this.controlList_ControlsToBeEnabledUponConnected.Add(this.groupBoxReadSpeed);
            this.controlList_ControlsToBeEnabledUponConnected.Add(this.buttonNewBaud);

            // Add the controls that we need to enable when the BLD04A is not connected.
            this.controlList_ControlsToBeEnabledUponDisconnected.Add(this.buttonRefreshComList);
            this.controlList_ControlsToBeEnabledUponDisconnected.Add(this.comboBoxComList);
            this.controlList_ControlsToBeEnabledUponDisconnected.Add(this.comboBoxBaudRateList);

            // Enable the related controls as the serial port is not connected.
            foreach (Control controlToBeEnabled in this.controlList_ControlsToBeEnabledUponDisconnected)
            {
                controlToBeEnabled.Enabled = true;
            }

            // Disable the related controls as the serial port is not connected.
            foreach (Control controlToBeDisabled in this.controlList_ControlsToBeEnabledUponConnected)
            {
                controlToBeDisabled.Enabled = false;
            }
            
        }



        private void formMain_FormClosing(object sender, FormClosingEventArgs e)
        {
            // If the serial port is already opened, close it.
            if (this.serialPort.IsOpen)
            {
                // Flush the buffers and close the serial port.
                this.serialPort.DiscardInBuffer();
                this.serialPort.DiscardOutBuffer();
                this.serialPort.Close();
            }
        }



        // This method allows the Form2 to disconnect the serial port.
        public void disconnectSerialPort()
        {
            // Disconnect the serial port if it's currently connected.
            if (this.serialPort.IsOpen == true)
            {
                this.buttonConnectDisconnect.PerformClick();
            }
        }

        
        
    }
}
